<?php
/*
	Team Password Manager (https://teampasswordmanager.com)

	Accessed Passwords Report

	Available data:

		- $user_id: Id of the user
		- $user_name: Name of the user
		- $user_username: Username of the user
		- $user_email: Email of the user

		- $total_rows: Number of items of $accessed_passwords_list
		- $accessed_passwords_list: Array of accessed passwords by the user, where each accessed password is an object with these attributes:
			- pwd_id: Id of the password
			- pwd_name: Name of the password
			- prj_id: Id of the project of the password
			- prj_name: Name of the project
			- archived: Is the project archived (0/1)?
			- pwdarchived: Is the password archived (0/1)?
			- pwd_locked: Is the password locked (0/1)?
			- pwd_linked: Is it a linked password (0/1)?
			- pwd_updated_on: Last date the password was updated
			- pwd_created_on: Date the password was created
			- last_accessed: Last date the password was accessed by the user
			- total_accesses: Number of times the password was accessed by the user
		- $ap_order_field: column by which the report is sorted by:
			- c = Created
			- u = Last Updated
			- a = Last Accessed (by the user)
			- t = Total Accesses (by the user)
		- $ap_order_ad: the sort order of the previous field:
			- asc = ascending
			- desc = descending
				
		(the index of the array is the id of the password)

	IMPORTANT: escape all output with the provided tpmesc() function below.
*/
	if ( !function_exists('tpmesc') ) {
		function tpmesc ( $str ) {
			if ( $str === null ) {
	            return '';
	        }
	        return htmlspecialchars((string)$str, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
		}
	}
?>

<!DOCTYPE html>
<html lang="<?php echo _lang('html_lang'); ?>">
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

	<title><?php echo _lang('v_users_rpt_accessed_passwords') . ': ' . tpmesc($user_name) . ' (' . tpmesc($user_id) . ')'; ?></title>

	<link rel="shortcut icon" type="image/x-icon" href="<?php echo base_url();?>css/printer.png" />

	<style>
		body {
		    font-family: arial, sans-serif;
		    font-size: 10pt;
		}

		.archived {
			background-color: #f89406;
			color: white;
			-webkit-border-radius: 3px;
    		-moz-border-radius: 3px;
    		border-radius: 3px;
    		display: inline-block;
    		padding: 2px 4px;
    		font-size: 8pt;
    		line-height: 14px;
    		vertical-align: baseline;
    		white-space: nowrap;
    		text-shadow: 0 -1px 0 rgba(0, 0, 0, .25);
		}

		@media print {
		    .no-print {
		        display: none !important;
		    }
		}

		.report-meta {
		    float:left;
		}

		.report-controls {
		    display: flex;
		    gap: 10px;
		    margin-bottom: 15px;
		    padding-left: 150px;
		    padding-top: 20px;
		}

		.report-controls button {
		    padding: 8px;
		    font-size: 14px;
		    cursor: pointer;
		}

		a:link,
		a:visited {
		    color: #08c;
		}
	</style>
</head>
<body>
	<div class="report-header">
		<div class="report-meta">
			<h1><img style="width: 28px" src="<?php echo base_url() . 'css/logo.jpg'; ?>" /> <?php echo _lang('v_users_rpt_accessed_passwords'); ?></h1>
	  		<p><strong>User</strong>: <?php echo tpmesc($user_name) . ' (' . tpmesc($user_id) . ' / ' . tpmesc($user_username) . ' / ' . tpmesc($user_email) . ')'; ?><br>
	  		<strong>Date</strong>: <?php echo tpmesc(date_time_tpm(date("Y-m-d H:i:s"))); ?><br>
	  		<strong><?php echo _lang('total_rows'); ?></strong>: <?php echo tpmesc($total_rows); ?></p>
	  	</div>
	  	<div class="report-controls no-print">
	    	<button onclick="window.print()">🖨 <?php echo _lang('g_print'); // Print ?></button>
	    	<button onclick="window.close()">✖ <?php echo _lang('g_close'); // Close ?></button>
		</div>
	</div>

	<div style="clear:both" />

	<?php if ( $accessed_passwords_list ) { ?>

	<table border="1" cellpadding="5" cellspacing="0">
		<thead>
	    	<tr>
				<th style="background-color: #08c; color:white"><?php echo _lang('cap_pwd'); // Password ?></strong><br><strong><?php echo mb_ucfirst(prj_sing()); // Project ?></th>
				<th style="background-color: #08c; color:white"><?php echo _lang('v_users_ap_created_on'); // Created ?>
					<?php 
						if ( $ap_order_field == 'c' ) {
							$img = 'asc.gif';
							if ( $ap_order_ad == 'desc' ) {
								$img = 'desc.gif';
							}
							?><img src="<?php echo base_url();?>css/<?php echo $img; ?>" />
							<?php
						}
					?>
				</th>
				<th style="background-color: #08c; color:white"><?php echo _lang('v_users_ap_last_updated_on'); // Last Updated ?>
					<?php 
						if ( $ap_order_field == 'u' ) {
							$img = 'asc.gif';
							if ( $ap_order_ad == 'desc' ) {
								$img = 'desc.gif';
							}
							?><img src="<?php echo base_url();?>css/<?php echo $img; ?>" />
							<?php
						}
					?>
				</th>
				<th style="background-color: #08c; color:white; font-weight: normal"><strong><?php echo _lang('v_users_ap_last_accessed'); // Last Accessed ?></strong>
					<?php 
						if ( $ap_order_field == 'a' ) {
							$img = 'asc.gif';
							if ( $ap_order_ad == 'desc' ) {
								$img = 'desc.gif';
							}
							?><img src="<?php echo base_url();?>css/<?php echo $img; ?>" />
							<?php
						}
					?>
					<br><?php echo _lang('v_users_ap_by_the_user'); // (by the User) ?>
				</th>
				<th style="background-color: #08c; color:white; font-weight: normal"><strong><?php echo _lang('v_users_ap_total_accesses'); // Total Accesses ?></strong>
					<?php 
						if ( $ap_order_field == 't' ) {
							$img = 'asc.gif';
							if ( $ap_order_ad == 'desc' ) {
								$img = 'desc.gif';
							}
							?><img src="<?php echo base_url();?>css/<?php echo $img; ?>" />
							<?php
						}
					?>
					<br><?php echo _lang('v_users_ap_by_the_user'); // (by the User) ?>
				</th>
		    </tr>
	  	</thead>
	  	<tbody>
		    <?php foreach ( $accessed_passwords_list as $pwd_id=>$pwd_access_item ) { ?>
				<tr>
		        	<td style="white-space: normal; overflow-wrap: anywhere; word-break: normal">
						<a href="<?php echo site_url('pwd/view/' . $pwd_access_item->pwd_id); ?>" >
							<?php echo tpmesc($pwd_access_item->pwd_name); ?> (<?php echo tpmesc($pwd_access_item->pwd_id); ?>)
						</a> 
						<?php if ( $pwd_access_item->pwdarchived ) { echo '<span style="margin-left: 3px" class="archived">A</span>'; } ?>
						<?php if ( $pwd_access_item->pwd_locked ) { echo '<img src="' . base_url() . 'css/locked.png' . '" />'; } ?>
						<?php if ( $pwd_access_item->pwd_linked ) { echo '<img src="' . base_url() . 'css/linked_password.png' . '" />'; } ?>
						<br>
						<a href="<?php echo site_url('prj/view/' . $pwd_access_item->prj_id); ?>" >
							<?php echo tpmesc($pwd_access_item->prj_name); ?> (<?php echo tpmesc($pwd_access_item->prj_id); ?>)
						</a>
						<?php if ( $pwd_access_item->archived ) { echo '<span style="margin-left: 3px" class="archived">A</span>'; }?>
		        	</td>
		        	<td style="text-align: center"><?php echo tpmesc(date_tpm($pwd_access_item->pwd_created_on)); ?></td>
		        	<td style="text-align: center"><?php echo tpmesc(date_tpm($pwd_access_item->pwd_updated_on)); ?></td>
		        	<td style="text-align: center"><?php echo tpmesc(date_tpm($pwd_access_item->last_accessed)); ?></td>
		        	<td style="text-align: center"><?php echo tpmesc($pwd_access_item->total_accesses); ?></td>
		      	</tr>
		    <?php } // foreach ?>
	  </tbody>
	</table>

	<?php 
		} else {
			echo  _lang('v_users_no_accessed_passwords'); // This user hasn't accessed any passwords
		} // if accessed_passwords_list 
	?>

</body>
</html>